#include "llvm/IR/Instruction.h"
#include "llvm/Transforms/Utils.h"
#include "llvm/Transforms/Utils/LoopPeel.h"
#include "llvm/Transforms/Utils/LoopSimplify.h"
#include "llvm/Transforms/Utils/LoopUtils.h"
#include "llvm/Transforms/Utils/SizeOpts.h"
#include "llvm/Transforms/Utils/UnrollLoop.h"
#include "llvm/Analysis/LoopAnalysisManager.h"
#include "llvm/Analysis/LoopInfo.h"
#include "llvm/Analysis/LoopUnrollAnalyzer.h"
#include "llvm/Transforms/Utils/BasicBlockUtils.h"
#include "llvm/Transforms/Utils/LoopUtils.h"
#include "llvm/ADT/Statistic.h"
#include "llvm/Pass.h"
#include "llvm/Analysis/LoopPass.h"
#include "llvm/IR/IRBuilder.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/IR/IRBuilder.h"
#include <algorithm>

using namespace llvm;

namespace {
struct OurLoopInversion : public LoopPass {
  std::vector<BasicBlock *> LoopBasicBlocks;

  static char ID; // Pass identification, replacement for typeid
  OurLoopInversion() : LoopPass(ID) {}

  void CopyInstructions()
  {
    std::unordered_map<Value *, Value *> Mapping;
    Instruction *Clone;
    BasicBlock *Header = LoopBasicBlocks.front();
    BasicBlock *Back = LoopBasicBlocks.back();

    Back->getTerminator()->eraseFromParent();

    IRBuilder<>Builder(Back->getContext());
    Builder.SetInsertPoint(Back);
    for (Instruction &I : *Header) {
      Clone = I.clone();
      Mapping[&I] = Clone;
      Builder.Insert(Clone);

      for (size_t i = 0; i < Clone->getNumOperands(); i++) {
        if (Mapping.find(Clone->getOperand(i)) != Mapping.end()) {
          Clone->setOperand(i, Mapping[Clone->getOperand(i)]);
        }
      }
    }
  }

  bool runOnLoop(Loop *L, LPPassManager &LPM) override {
    mapVariables(L);
    LoopBasicBlocks = L->getBlocksVector();

    CopyInstructions();
    return true;
  }
}; // end of struct OurLoopInversion
}  // end of anonymous namespace

char OurLoopInversion::ID = 0;
static RegisterPass<OurLoopInversion> X("loop-inversion", "",
                                              false /* Only looks at CFG */,
                                              false /* Analysis Pass */);