#include "llvm/Pass.h"
#include "llvm/IR/Module.h"
#include "llvm/Support/raw_ostream.h"
#include "OurCallGraph.h"

using namespace llvm;

namespace {
struct OurCallGraphPass : public ModulePass {
  static char ID;
  OurCallGraphPass() : ModulePass(ID) {}

  bool runOnModule(Module &M) override {
    OurCallGraph *CallGraph = new OurCallGraph(M);
    CallGraph->dumpGraphToFile();

    delete CallGraph;
    return false;
  }
};
}

char OurCallGraphPass::ID = 0;
static RegisterPass<OurCallGraphPass> X("our-call-graph-pass", "Our call graph pass",
                             false /* Only looks at CFG */,
                             false /* Analysis Pass */);