#include "llvm/IR/Function.h"
#include "llvm/Pass.h"
#include "llvm/Support/raw_ostream.h"
#include <unordered_map>
#include <iostream>

using namespace llvm;

namespace {
struct OurSimpleFunctionPass : public FunctionPass {
  static char ID; // Pass identification, replacement for typeid
  OurSimpleFunctionPass() : FunctionPass(ID) {}

  bool runOnFunction(Function &F) override {
    std::unordered_map<std::string, int> opcodes_counter;

    for (const BasicBlock &BB : F) {
      for (const Instruction &Instr : BB) {
        opcodes_counter[std::string(Instr.getOpcodeName())]++;
      }
    }

    std::cout << "Function: " << F.getName().str() << ":\n";
    for (const auto &p : opcodes_counter) {
      std::cout << "Opcode: " << p.first << " occurs: " << p.second << " times!\n";
    }
    return false;
  }
};
}

char OurSimpleFunctionPass::ID = 17;
static RegisterPass<OurSimpleFunctionPass> X("our-simple-function-pass", "Counts occurrences of each opcode");
