//
// Created by strahinja on 3/6/24.
//

#include "OurCallGraph.h"

OurCallGraph::OurCallGraph(Module &M)
{
  moduleName = M.getName().str();

  Function *Main = M.getFunction("main");

  if (Main == NULL) {
    errs() << "Main does not exist!\n";
    exit(1);
  }

  createCallGraph(M);
}

void OurCallGraph::createCallGraph(llvm::Function *F)
{
  for (const auto &BB : *F) {
    for (const auto &Instr : BB) {
      if (auto CallInstr = dyn_cast<CallInst>(&Instr)) {
        Function *Callee = CallInstr->getCalledFunction();
        adjacency_list[F].insert(Callee);
        if (adjacency_list.find(Callee) == adjacency_list.end()) {
          adjacency_list[Callee] = {};
          createCallGraph(Callee);
        }
      }
    }
  }
}

void OurCallGraph::createCallGraph(Module &M)
{
  for (auto &F : M) {
    adjacency_list[&F] = {};
    for (const auto &BB : F) {
      for (const auto &Instr : BB) {
        if (auto CallInstr = dyn_cast<CallInst>(&Instr)) {
          Function *Callee = CallInstr->getCalledFunction();
          adjacency_list[&F].insert(Callee);
        }
      }
    }
  }
}

void OurCallGraph::dumpCallGraph()
{
  std::ofstream File;
  File.open(moduleName + ".dot");

  File << "digraph \"Call graph: " << moduleName <<"\" {\n";
  File << "\tlabel=\"Our text: " << moduleName << "\";\n\n";

  for (const auto &p : adjacency_list) {
    File << "\tNode" << p.first << " [shape=record,label=\"{" << p.first->getName().str() << "}\"]\n";
    for (Function *Callee : p.second) {
      File << "\tNode" << p.first << " -> Node" << Callee << ";\n";
    }
  }
  File << "}\n";
}
