#include "llvm/Pass.h"
#include "llvm/IR/Module.h"
#include "llvm/Support/raw_ostream.h"
#include <unordered_map>
#include "OurCallGraph.h"

using namespace llvm;

namespace {
struct OurCallGraphPass : public ModulePass {
  static char ID;
  OurCallGraphPass() : ModulePass(ID) {}

  bool runOnModule(Module &M) override {
    OurCallGraph *Graph = new OurCallGraph(M);

    Graph->dumpCallGraph();

    delete Graph;

    return false;
  }
};
}

char OurCallGraphPass::ID = 0;
static RegisterPass<OurCallGraphPass> X("callgraph-pass", "Hello World Pass",
                                     false /* Only looks at CFG */,
                                     false /* Analysis Pass */);