#include "llvm/Pass.h"
#include "llvm/IR/Function.h"
#include "llvm/Support/raw_ostream.h"
#include <unordered_map>
#include <iostream>

using namespace llvm;

namespace {
struct OurFunctionPass : public FunctionPass {
  static char ID;
  OurFunctionPass() : FunctionPass(ID) {}

  bool runOnFunction(Function &F) override {
    std::unordered_map<std::string, int> opcodes;
    for (const BasicBlock &BB : F) {
      for (const Instruction &Instr : BB) {
        opcodes[std::string(Instr.getOpcodeName())]++;
      }
    }

    std::cout << F.getName().str() << ":\n";
    for (const auto &p : opcodes)  {
      std::cout << p.first << " occurs " << p.second << " times!\n";
    }

    return false;
  }
};
}

char OurFunctionPass::ID = 0;
static RegisterPass<OurFunctionPass> X("simple-function-pass", "Our simple pass that counts opcodes in each function",
                             false /* Only looks at CFG */,
                             false /* Analysis Pass */);