#include "llvm/Pass.h"
#include "llvm/IR/Function.h"
#include "OurCFG.h"

using namespace llvm;

namespace {
struct OurCFGPass : public FunctionPass {
  static char ID;
  OurCFGPass() : FunctionPass(ID) {}

  bool runOnFunction(Function &F) override {
    OurCFG *CFG = new OurCFG(F);
    CFG->DumpGraphToFile();

    delete CFG;
    return false;
  }
};
}

char OurCFGPass::ID = 0;
static RegisterPass<OurCFGPass> X("our-cfg", "Our simple CFG implementation",
                             false /* Only looks at CFG */,
                             false /* Analysis Pass */);