/* implementacija klase */
#include "SymbolTable.hpp"

int SymbolTable::GetValue(const std::string& s) const {

    auto it = _promenljive.find(s);

    /* u tablici simbola cuvamo primitivne tipove, pa moramo da bacamo 
     * izuzetke kao obavestenje gresci. kada koristimo pokazivace, mozemo
     * da vratimo nullptr kao signal greske i time da izbegnemo izuzetke
     */
    if (it == _promenljive.end())
        throw std::invalid_argument("Promenljiva nije definisana");

    return it->second;
}
void SymbolTable::DefineValue(const std::string& s, int val) {

    _promenljive[s] = val;
}