/* hijerahija klasa koja opisuje cvorove 
 * hijerarhija pravi model koji smo koristil do sada i nece biti posebno komentarisana
 */
#include "SynTree.hpp"

std::ostream& operator <<(std::ostream& s, const SyntaxTreeNode& stn){

    stn.Print(s);
    return s;
}

ConstantNode::ConstantNode(int v) {
    _value = v;
}

void ConstantNode::Print(std::ostream& s) const {
    s << _value;
}
SyntaxTreeNode* ConstantNode::Clone() const {
    return new ConstantNode(*this);
}

int ConstantNode::Interpret(SymbolTable& st) const {
    return _value;
}

IdentifierNode::IdentifierNode(const std::string& s) {
    _value = s;
}

void IdentifierNode::Print(std::ostream& s) const {
    s << _value;
}
SyntaxTreeNode* IdentifierNode::Clone() const {
    return new IdentifierNode(*this);
}

int IdentifierNode::Interpret(SymbolTable& st) const {

    return st.GetValue(_value);
}

SuprotniCvor::SuprotniCvor(SyntaxTreeNode* exp){
    _expr = exp;
}
SuprotniCvor::SuprotniCvor(const SuprotniCvor& sc) {
    _expr = sc._expr->Clone();
}
SuprotniCvor::~SuprotniCvor() {
    delete _expr;
}

void SuprotniCvor::Print(std::ostream& s) const {
    s << "-(" << (*_expr) << ")";
}
SyntaxTreeNode* SuprotniCvor::Clone() const{ 
    return new SuprotniCvor(*this);
}

int SuprotniCvor::Interpret(SymbolTable& st) const {
    
    return -_expr->Interpret(st);
}

GroupNode::GroupNode(SyntaxTreeNode* exp) {
    _expr = exp;
}
GroupNode::GroupNode(const GroupNode& sc) {
    _expr = sc._expr->Clone();
}
GroupNode::~GroupNode() {
    delete _expr;
}

void GroupNode::Print(std::ostream& s) const{
    s << "(" << (*_expr) <<")";
}
SyntaxTreeNode* GroupNode::Clone() const{
    return new GroupNode(*this);
}

int GroupNode::Interpret(SymbolTable& st) const {
    return _expr->Interpret(st);
}

BinaryOperator::BinaryOperator(const std::string &s, 
        SyntaxTreeNode* l, SyntaxTreeNode* r) {
            _symbol = s;
            _left = l;
            _right = r;
        }
BinaryOperator::~BinaryOperator() {
    delete _left;
    delete _right;
}

void BinaryOperator::Print(std::ostream& s) const {
    s << (*_left) << " " << _symbol << " " << (*_right); 
}

PlusNode::PlusNode(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator("+", l, r) {

    }
PlusNode::PlusNode(const PlusNode& pn) 
    : BinaryOperator("+", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* PlusNode::Clone() const {
    return new PlusNode(*this);
}
int PlusNode::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) + _right->Interpret(st);
}

MinusNode::MinusNode(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator("-", l, r) {

    }
MinusNode::MinusNode(const MinusNode& pn) 
    : BinaryOperator("-", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* MinusNode::Clone() const {
    return new MinusNode(*this);
}
int MinusNode::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) - _right->Interpret(st);
}

PutaCvor::PutaCvor(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator("*", l, r) {

    }
PutaCvor::PutaCvor(const PutaCvor& pn) 
    : BinaryOperator("*", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* PutaCvor::Clone() const {
    return new PutaCvor(*this);
}
int PutaCvor::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) * _right->Interpret(st);
}

PodeljenoCvor::PodeljenoCvor(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator("/", l, r) {

    }
PodeljenoCvor::PodeljenoCvor(const PodeljenoCvor& pn) 
    : BinaryOperator("/", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* PodeljenoCvor::Clone() const {
    return new PodeljenoCvor(*this);
}
int PodeljenoCvor::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) / _right->Interpret(st);
}

EqualNode::EqualNode(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator("==", l, r) {

    }
EqualNode::EqualNode(const EqualNode& pn) 
    : BinaryOperator("==", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* EqualNode::Clone() const {
    return new EqualNode(*this);
}
int EqualNode::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) == _right->Interpret(st);
}

NotEqualNode::NotEqualNode(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator("!=", l, r) {

    }
NotEqualNode::NotEqualNode(const NotEqualNode& pn) 
    : BinaryOperator("!=", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* NotEqualNode::Clone() const {
    return new NotEqualNode(*this);
}
int NotEqualNode::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) != _right->Interpret(st);
}

LowerNode::LowerNode(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator("<", l, r) {

    }
LowerNode::LowerNode(const LowerNode& pn) 
    : BinaryOperator("<", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* LowerNode::Clone() const {
    return new LowerNode(*this);
}
int LowerNode::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) < _right->Interpret(st);
}

GreaterNode::GreaterNode(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator(">", l, r) {

    }
GreaterNode::GreaterNode(const GreaterNode& pn) 
    : BinaryOperator(">", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* GreaterNode::Clone() const {
    return new GreaterNode(*this);
}
int GreaterNode::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) > _right->Interpret(st);
}

GreaterEqualNode::GreaterEqualNode(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator(">=", l, r) {

    }
GreaterEqualNode::GreaterEqualNode(const GreaterEqualNode& pn) 
    : BinaryOperator(">=", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* GreaterEqualNode::Clone() const {
    return new GreaterEqualNode(*this);
}
int GreaterEqualNode::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) >= _right->Interpret(st);
}

LowerEqualNode::LowerEqualNode(SyntaxTreeNode* l, SyntaxTreeNode* r)
    : BinaryOperator("<=", l, r) {

    }
LowerEqualNode::LowerEqualNode(const LowerEqualNode& pn) 
    : BinaryOperator("<=", pn._left->Clone(), pn._right->Clone()){

}

SyntaxTreeNode* LowerEqualNode::Clone() const {
    return new LowerEqualNode(*this);
}
int LowerEqualNode::Interpret(SymbolTable& st) const {
    return _left->Interpret(st) <= _right->Interpret(st);
}

AssignmentNode::AssignmentNode(const std::string& n, SyntaxTreeNode* exp) {
    _name = n;
    _expr = exp;
}
AssignmentNode::AssignmentNode(const AssignmentNode& an) {
    _name = an._name;
    _expr = an._expr->Clone();
}
AssignmentNode::~AssignmentNode() {
    delete _expr;
}

void AssignmentNode::Print(std::ostream& s) const {
    s << _name << " := " << (*_expr) << ";";
}
SyntaxTreeNode* AssignmentNode::Clone() const {
    return new AssignmentNode(*this);
}

int AssignmentNode::Interpret(SymbolTable& st) const {
    int rez = _expr->Interpret(st);
    st.DefineValue(_name, rez);
    return rez;
}

PrintNode::PrintNode(SyntaxTreeNode* exp) {
    _expr = exp;
}
PrintNode::PrintNode(const PrintNode& an) {
    _expr = an._expr->Clone();
}
PrintNode::~PrintNode() {
    delete _expr;
}

void PrintNode::Print(std::ostream& s) const {
    s << "print(" << (*_expr) << ")";
}
SyntaxTreeNode* PrintNode::Clone() const {
    return new PrintNode(*this);
}

int PrintNode::Interpret(SymbolTable& st) const {

    std::cout << (_expr->Interpret(st)) << std::endl;
    return 0;
}

WhileNode::WhileNode(SyntaxTreeNode* cond, SyntaxTreeNode* exp) {
    _uslov = cond;
    _expr = exp;
}
WhileNode::WhileNode(const WhileNode& an) {
    _uslov = an._uslov->Clone();
    _expr = an._expr->Clone();
}
WhileNode::~WhileNode() {
    delete _uslov;
    delete _expr;
}

void WhileNode::Print(std::ostream& s) const {
    s << "while " << (*_uslov) << " do" << std::endl;
    s << (*_expr);
}
SyntaxTreeNode* WhileNode::Clone() const {
    return new WhileNode(*this);
}

int WhileNode::Interpret(SymbolTable& st) const {

    while (_uslov->Interpret(st)) {
        _expr->Interpret(st);
    }

    return 0;
}

SubProgramNode::SubProgramNode(SyntaxTreeNode* exp) {
    _expr = exp;
}
SubProgramNode::SubProgramNode(const SubProgramNode& an) {
    _expr = an._expr->Clone();
}
SubProgramNode::~SubProgramNode() {
    delete _expr;
}

void SubProgramNode::Print(std::ostream& s) const {
    s << "begin" << std::endl;
    s << (*_expr) << std::endl;
    s << "end";
}
SyntaxTreeNode* SubProgramNode::Clone() const {
    return new SubProgramNode(*this);
}

int SubProgramNode::Interpret(SymbolTable& st) const {

    return _expr->Interpret(st);
}

IfNoElseNode::IfNoElseNode(SyntaxTreeNode* cond, SyntaxTreeNode* exp) {
    _uslov = cond;
    _expr = exp;
}
IfNoElseNode::IfNoElseNode(const IfNoElseNode& an) {
    _uslov = an._uslov->Clone();
    _expr = an._expr->Clone();
}
IfNoElseNode::~IfNoElseNode() {
    delete _uslov;
    delete _expr;
}

void IfNoElseNode::Print(std::ostream& s) const {
    s << "if " << (*_uslov) << " then" << std::endl;
    s << (*_expr);
}
SyntaxTreeNode* IfNoElseNode::Clone() const {
    return new IfNoElseNode(*this);
}

int IfNoElseNode::Interpret(SymbolTable& st) const {

    if (_uslov->Interpret(st)) {
        _expr->Interpret(st);
    }

    return 0;
}

IfElseNode::IfElseNode(SyntaxTreeNode* cond, SyntaxTreeNode* exp1, SyntaxTreeNode* exp2) {
    _uslov = cond;
    _expr1 = exp1;
    _expr2 = exp2;
}
IfElseNode::IfElseNode(const IfElseNode& an){
    _uslov = an._uslov->Clone();
    _expr1 = an._expr1->Clone();
    _expr2 = an._expr2->Clone();
}
IfElseNode::~IfElseNode() {
    delete _uslov;
    delete _expr1;
    delete _expr2;
}

void IfElseNode::Print(std::ostream& s) const {
    s << "if " << (*_uslov) << " then" << std::endl;
    s << (*_expr1) << std::endl;
    s << "else " << std::endl;
    s << (*_expr2) << std::endl;
}
SyntaxTreeNode* IfElseNode::Clone() const {
    return new IfElseNode(*this);
}

int IfElseNode::Interpret(SymbolTable& st) const {
    if (_uslov->Interpret(st)) {
        _expr1->Interpret(st);
    }
    else {
        _expr2->Interpret(st);
    }

    return 0;
}

SequenceNode::SequenceNode(const SequenceNode& sn) {
    for (int i = 0; i < sn._stmts.size(); i++) {
        _stmts.push_back(sn._stmts[i]->Clone());
    }
}
SequenceNode::~SequenceNode() {
    for (int i = 0; i < _stmts.size(); i++) {
        delete _stmts[i];
    }
}

void SequenceNode::Add(SyntaxTreeNode* stm){

    _stmts.push_back(stm);
}
void SequenceNode::Print(std::ostream& s) const {
    for (int i = 0; i < _stmts.size(); i++) {
        s << (*_stmts[i]) << std::endl;
    }
}
SyntaxTreeNode* SequenceNode::Clone() const {
    return new SequenceNode(*this);
}

int SequenceNode::Interpret(SymbolTable& st) const {
    for (int i = 0; i < _stmts.size(); i++) {
        _stmts[i]->Interpret(st);
    }
    return 0;
}