/* hijerahija klasa koja opisuje cvorove 
 * hijerarhija pravi model koji smo koristil do sada i nece biti posebno komentarisana
 */
#ifndef SYN_TREE_H
#define SYN_TREE_H

#include <iostream>
#include <vector>
#include "SymbolTable.hpp"

class SyntaxTreeNode {
public:
    virtual ~SyntaxTreeNode() {}

    virtual void Print(std::ostream& s) const = 0;
    virtual SyntaxTreeNode* Clone() const = 0;

    virtual int Interpret(SymbolTable& st) const = 0;
};

std::ostream& operator <<(std::ostream& s, const SyntaxTreeNode& stn);

class ConstantNode : public SyntaxTreeNode {
private:
    int _value;
public:
    ConstantNode(int v);

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class IdentifierNode : public SyntaxTreeNode {
private:
    std::string _value;
public:
    IdentifierNode(const std::string& s);

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class SuprotniCvor : public SyntaxTreeNode {
private:
    SyntaxTreeNode* _expr;
public:
    SuprotniCvor(SyntaxTreeNode* exp);
    SuprotniCvor(const SuprotniCvor& sc);
    ~SuprotniCvor();

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class GroupNode : public SyntaxTreeNode {
private:
    SyntaxTreeNode* _expr;
public:
    GroupNode(SyntaxTreeNode* exp);
    GroupNode(const GroupNode& sc);
    ~GroupNode();

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class BinaryOperator : public SyntaxTreeNode {
protected:
    std::string _symbol;
    SyntaxTreeNode* _left;
    SyntaxTreeNode* _right;
public:
    BinaryOperator(const std::string &s, 
        SyntaxTreeNode* l, SyntaxTreeNode* r);
    ~BinaryOperator();

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const = 0;

    virtual int Interpret(SymbolTable& st) const = 0;
};

class PlusNode : public BinaryOperator {

public:
    PlusNode(SyntaxTreeNode* l, SyntaxTreeNode* r);
    PlusNode(const PlusNode& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class MinusNode : public BinaryOperator {

public:
    MinusNode(SyntaxTreeNode* l, SyntaxTreeNode* r);
    MinusNode(const MinusNode& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class PutaCvor : public BinaryOperator {

public:
    PutaCvor(SyntaxTreeNode* l, SyntaxTreeNode* r);
    PutaCvor(const PutaCvor& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class PodeljenoCvor : public BinaryOperator {

public:
    PodeljenoCvor(SyntaxTreeNode* l, SyntaxTreeNode* r);
    PodeljenoCvor(const PodeljenoCvor& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class EqualNode : public BinaryOperator {

public:
    EqualNode(SyntaxTreeNode* l, SyntaxTreeNode* r);
    EqualNode(const EqualNode& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class NotEqualNode : public BinaryOperator {

public:
    NotEqualNode(SyntaxTreeNode* l, SyntaxTreeNode* r);
    NotEqualNode(const NotEqualNode& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class GreaterNode : public BinaryOperator {

public:
    GreaterNode(SyntaxTreeNode* l, SyntaxTreeNode* r);
    GreaterNode(const GreaterNode& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class GreaterEqualNode : public BinaryOperator {

public:
    GreaterEqualNode(SyntaxTreeNode* l, SyntaxTreeNode* r);
    GreaterEqualNode(const GreaterEqualNode& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class LowerNode : public BinaryOperator {

public:
    LowerNode(SyntaxTreeNode* l, SyntaxTreeNode* r);
    LowerNode(const LowerNode& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class LowerEqualNode : public BinaryOperator {

public:
    LowerEqualNode(SyntaxTreeNode* l, SyntaxTreeNode* r);
    LowerEqualNode(const LowerEqualNode& pn);

    virtual SyntaxTreeNode* Clone() const;
    virtual int Interpret(SymbolTable& st) const;
};

class AssignmentNode : public SyntaxTreeNode {
private:
    std::string _name;
    SyntaxTreeNode* _expr;
public:
    AssignmentNode(const std::string& n, SyntaxTreeNode* exp);
    AssignmentNode(const AssignmentNode& an);
    ~AssignmentNode();

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class PrintNode : public SyntaxTreeNode {
private:
    SyntaxTreeNode* _expr;
public:
    PrintNode(SyntaxTreeNode* exp);
    PrintNode(const PrintNode& an);
    ~PrintNode();

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class WhileNode : public SyntaxTreeNode {
private:
    SyntaxTreeNode* _uslov;
    SyntaxTreeNode* _expr;
public:
    WhileNode(SyntaxTreeNode* cond, SyntaxTreeNode* exp);
    WhileNode(const WhileNode& an);
    ~WhileNode();

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class SubProgramNode : public SyntaxTreeNode {
private:
    SyntaxTreeNode* _expr;
public:
    SubProgramNode(SyntaxTreeNode* exp);
    SubProgramNode(const SubProgramNode& an);
    ~SubProgramNode();

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class IfNoElseNode : public SyntaxTreeNode {
private:
    SyntaxTreeNode* _uslov;
    SyntaxTreeNode* _expr;
public:
    IfNoElseNode(SyntaxTreeNode* cond, SyntaxTreeNode* exp);
    IfNoElseNode(const IfNoElseNode& an);
    ~IfNoElseNode();

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class IfElseNode : public SyntaxTreeNode {
private:
    SyntaxTreeNode* _uslov;
    SyntaxTreeNode* _expr1;
    SyntaxTreeNode* _expr2;
public:
    IfElseNode(SyntaxTreeNode* cond, SyntaxTreeNode* exp1, SyntaxTreeNode* exp2);
    IfElseNode(const IfElseNode& an);
    ~IfElseNode();

    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

class SequenceNode : public SyntaxTreeNode {

private:
    std::vector<SyntaxTreeNode*> _stmts;
public:
    SequenceNode() {}
    SequenceNode(const SequenceNode& sn);
    ~SequenceNode();

    void Add(SyntaxTreeNode* stm);
    virtual void Print(std::ostream& s) const;
    virtual SyntaxTreeNode* Clone() const;

    virtual int Interpret(SymbolTable& st) const;
};

#endif

