%option noyywrap

%{
    #include <iostream>
    #include <stdlib.h>

    /* ukljucujmo potrebna zaglavlja */
    #include "SymbolTable.hpp"
    #include "SynTree.hpp"

    #include "parser.tab.hpp"    
%}

%%

print   {return PRINT_T;}
while   {return WHILE_T;}
do      {return DO_T;}
then    {return THEN_T;}
if      {return IF_T;}
else    {return ELSE_T;}
begin   {return BEGIN_T;}
end     {return END_T;}
[0-9]+  {
            yylval.v = atoi(yytext);
            return BROJ_T;
        }
[A-Za-z_][A-Za-z0-9_]*  {
            yylval.s = new std::string(yytext);
            return ID_T;
        }
":="    {return DODELA_T;}
"<="    {return LEQ_T;}
">="    {return GEQ_T;}
[+*/();.<>-]  {return *yytext;}
[ \t\n] { }
.       {
            std::cerr << "Leksicka greska: " 
                    << (*yytext) << std::endl;
            exit(EXIT_FAILURE);
        }    

%%