%option noyywrap

%{
    #include <iostream>
    #include <cstdlib>

    #include "tokeni.h"    
%}

%%
print  {return PRINT_T;}
[A-Za-z_][A-Za-z0-9_]*  {return ID_T;}
[0-9]+  {return BROJ_T;}
"+" {return PLUS_T;}
"-" {return MINUS_T;}
"/" {return PODELJENO_T;}
"*" {return PUTA_T;}
"(" {return OZ_T;}
")" {return ZZ_T;}
";" {return TZ_T;}
"=" {return JEDNAKO_T;}
[ \t\n] {}
.   {
        std::cerr<<"Leksicka greska: "<<(*yytext)<<std::endl;
        exit(EXIT_FAILURE);
    }

%%