/* Dat je jednostavan jezik aritmetickih izraza koji omogucava definisanje celobrojnih 
 * promenljivih i njihov prikaz. Napisati LL(1) parser koji proverava sintaksnu ispravnost
 * programa napisanih na datom jeziku. 
 * 
 * Primer:
 * a = 2+3*(4/b + 6 - 2*(4*c - 3));
 * print(-2*a);
 */

/*
Naivna gramatika:
program ->  program naredba     (levo rekurzivno pravilo)
            | naredba
naredba->   id = E ;
            | print (E);
E ->    E + T                   (levo rekurzivno pravilo)
        | T
T ->    T * F                   (levo rekurzivno pravilo)
        | F
F ->    broj
        | id
        | ( E )
        | - broj                (unarni minus)

Eliminisemo levu rekruziju:

program: naredba programP       
programP: naredba programP      
    | eps                       
naredba: ID = E ;               
         PRINT_T ( E ) ;        
E   -> T EP                     
EP  -> + T EP                   
       - T EP                   
       eps                      
T   -> F TP                     
TP  -> * F TP                   
       / F TP                   
       eps                      
F   -> ( E )                    
       broj                     
       ID                       
       - broj

Odredjujemo skupove izbora:

Simbol      |   First           | Eps   |   Follow
-------------------------------------------------------------
program     | id, print         | /     |   EOI
-------------------------------------------------------------
programP    | id, print         | Da    |   EOI
-------------------------------------------------------------
naredba     | id, print         | /     |   id, print
-------------------------------------------------------------
E           | id, broj, (, -    | /     |   ;, )
-------------------------------------------------------------
EP          | +, -              | Da    |   ;, )
-------------------------------------------------------------
T           | id, broj, (, -    | /     |   ;, )
-------------------------------------------------------------
TP          | *, /              | Da    |   +, -, ;, )
-------------------------------------------------------------
F           | id, broj, (, -    | /     |   *, /, +, -, ;, )
-------------------------------------------------------------


Konacna gramatika sa odredjenim skupovima izbora:

program: naredba programP       ID, PRINT_T
programP: naredba programP      ID, PRINT_T
    | eps                       EOI 
naredba: ID = E ;               ID
         PRINT_T ( E ) ;        PRINT_T
E   -> T EP                     BROJ, (, ID, -
EP  -> + T EP                   +
       - T EP                   -
       eps                      ;, )
T   -> F TP                     BROJ, (, ID, -
TP  -> * F TP                   *
       / F TP                   /
       eps                      +. -. ;, )
F   -> ( E )                    (
       broj                     broj
       ID                       ID
       - broj                   -

Dobijena gramatika je LL(1), tj. u svakom pravilu je moguce na osnovu jednog
preduvidnog simbola zakljuciti koji je sledeci korak u izvodjenju. Gramatika je LL(1)
ako:
1. Nije levo rekurzivna, niti levo faktorisana. 
2. Skupovi izbora su disjunktni. Preciznije, ako pravilo ima vise od jedne moguce grane
   tada svi preseci skupova izbora po parovima moraju biti prazni. 

Sledi implementacija parsera pomocu potisnog automata. Potisni automat koristi struktur podataka
stek u lokalnom adresnom prostoru da bi cuvao tekuce izvodjenje. Svaki neterminal predstavljen je 
odgovarajucim kodom koji ne sme biti jednak nijednom tokenu, jer na steku istovremeno cuvamo i tokene
i neterminale. Parsiranje se sukcesivnim zamenama tokene i neterminala na vrhu steka cime se 
simulira zamena leve strane pravila desnom stranom pravila. 
*/


#include <iostream>
#include <cstdlib>
/* koristimo ugradjenu strukturu podataka stek. nema potrebe da implementirate stek od nule */
#include <stack>

/* ukljucujemo spisak tokena i neterminala */
#include "tokeni.h"

/* lokalni mehanizam debagovanja izvodjenja */
#define DEBUG (1)

/* linkujemo leksicki analizator */
extern int yylex();


/* glavni program */
int main() {

    /* kreiramo stek na koje mcuvamo tekuce stanje parsiranja */
    std::stack<int> stek;
    /* ucitavamo prvi token sa ulaza */
    int preduvid = yylex();
    /* na stek postavljamo startni simbol gramatike */
    stek.push(PROGRAM);

    /* sve dok ne ispraznimo stek */
    while (!stek.empty()) {
        /* proveravamo sta je na vrhu steka:
         * 1. neterminale skidamo sa vrha steka i zamenjujemo ih desnom stranom pravila 
         *    (simbole sa desne strane pravila dodajemo na stek u obrnutom poretku)
         * 2. Tokene uporedjujemo sa preduvidnim simbolom i ako su isti skidamo ih i nastavljamo dalje.
         *    ako token sa vrha steka i preduvidni simbol nisu isti radi se o sintaksnoj gresci, pa prekidamo parsiranje. 
         */
        switch (stek.top()) {
/************************** Program *************************/            
            case PROGRAM:
                /* ako je na ulazu token koji pripada skupu izbora */
                if (preduvid == ID_T || preduvid == PRINT_T) {
#ifdef DEBUG
    std::cout << "Program -> naredba programP" << std::endl;
#endif              
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(PROGRAMP);
                    stek.push(NAREDBA);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                /* ako je na ulazu token koji ne pripada skupovima izbora */
                else {
                    /* prijavljujemo gresku i prekidamo parsiranje */
                    std::cerr << "Sintaksna greska:" 
                        << "Ocekivano: ID_T, PRINT_T"<< std::endl;
                    exit(EXIT_FAILURE);
                }
                break;
/************************** ProgramP *************************/            
            case PROGRAMP:
                if (preduvid == ID_T || preduvid == PRINT_T) {
#ifdef DEBUG
    std::cout << "ProgramP -> naredba programP" << std::endl;
#endif                    
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(PROGRAMP);
                    stek.push(NAREDBA);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                else if (preduvid == EOI) {
#ifdef DEBUG
    std::cout << "ProgramP -> eps" << std::endl;
#endif
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                }
                /* ako je na ulazu token koji ne pripada skupovima izbora */
                else {
                    /* prijavljujemo gresku i prekidamo parsiranje */
                    std::cerr << "Sintaksna greska:" 
                        << "Ocekivano: ID_T, PRINT_T, EOI"<< std::endl;
                    exit(EXIT_FAILURE);
                }
                break;
/************************** Naredba *************************/            
            case NAREDBA:
                if (preduvid == ID_T) {
#ifdef DEBUG
    std::cout << "naredba -> id = E ;" << std::endl;
#endif
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(TZ_T);
                    stek.push(E);
                    stek.push(JEDNAKO_T);
                    stek.push(ID_T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                else if (preduvid == PRINT_T) {
#ifdef DEBUG
    std::cout << "naredba -> print ( E ) ;" << std::endl;
#endif
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(TZ_T);
                    stek.push(ZZ_T);
                    stek.push(E);
                    stek.push(OZ_T);
                    stek.push(PRINT_T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                /* ako je na ulazu token koji ne pripada skupovima izbora */
                else {
                    /* prijavljujemo gresku i prekidamo parsiranje */
                    std::cerr << "Sintaksna greska:" 
                        << "Ocekivano: ID_T, PRINT_T, EOI"<< std::endl;
                    exit(EXIT_FAILURE);
                }
                break;
/************************** E *************************/            
            case E:
                if (preduvid == ID_T || preduvid == BROJ_T || preduvid == OZ_T || preduvid == MINUS_T) {
#ifdef DEBUG
    std::cout << "E -> T EP" << std::endl;
#endif                    
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(EP);
                    stek.push(T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                /* ako je na ulazu token koji ne pripada skupovima izbora */
                else {
                    /* prijavljujemo gresku i prekidamo parsiranje */
                    std::cerr << "Sintaksna greska:" 
                        << "Ocekivano: ID_T, BROJ_T, OZ_T"<< std::endl;
                    exit(EXIT_FAILURE);
                }
                break;
/************************** EP *************************/            
            case EP:
                if (preduvid == PLUS_T) {
#ifdef DEBUG
    std::cout << "EP -> + T EP" << std::endl;
#endif                    
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(EP);
                    stek.push(T);
                    stek.push(PLUS_T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                else if (preduvid == MINUS_T) {
#ifdef DEBUG
    std::cout << "EP -> - T EP" << std::endl;
#endif 
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(EP);
                    stek.push(T);
                    stek.push(MINUS_T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                else if (preduvid == TZ_T || preduvid == ZZ_T) {
#ifdef DEBUG
    std::cout << "EP -> eps" << std::endl;
#endif                     
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                }
                /* ako je na ulazu token koji ne pripada skupovima izbora */
                else {
                    std::cerr << "Sintaksna greska:" 
                        << "Ocekivano: +, -, ), ;"<< std::endl;
                    exit(EXIT_FAILURE);
                }
                break;
/************************** T *************************/            
            case T:
                if (preduvid == BROJ_T || preduvid == ID_T || preduvid == OZ_T || preduvid == MINUS_T) {
#ifdef DEBUG
    std::cout << "T -> F TP" << std::endl;
#endif                     
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(TP);
                    stek.push(F);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                /* ako je na ulazu token koji ne pripada skupovima izbora */
                else {
                    /* prijavljujemo gresku i prekidamo parsiranje */
                    std::cerr << "Sintaksna greska:" 
                        << "Ocekivano: ID_T, BROJ_T, OZ_T"<< std::endl;
                    exit(EXIT_FAILURE);
                }
                break;
/************************** TP *************************/            
            case TP:
                if (preduvid == PUTA_T) {
#ifdef DEBUG
    std::cout << "TP -> * F TP" << std::endl;
#endif 
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(TP);
                    stek.push(F);
                    stek.push(PUTA_T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                else if (preduvid == PODELJENO_T) {
#ifdef DEBUG
    std::cout << "TP -> / F TP" << std::endl;
#endif                     
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(TP);
                    stek.push(F);
                    stek.push(PODELJENO_T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                else if (preduvid == PLUS_T || preduvid == MINUS_T 
                    || preduvid == TZ_T || preduvid == ZZ_T) {
#ifdef DEBUG
    std::cout << "TP -> eps" << std::endl;
#endif                         
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                }
                /* ako je na ulazu token koji ne pripada skupovima izbora */
                else {
                    /* prijavljujemo gresku i prekidamo parsiranje */
                    std::cerr << "Sintaksna greska:" 
                        << "Ocekivano: +, -, *, /, ;, )"<< std::endl;
                    exit(EXIT_FAILURE);
                }
                break;
/************************** F *************************/            
            case F:
                if (preduvid == MINUS_T) {
 #ifdef DEBUG
    std::cout << "F -> - broj" << std::endl;
#endif 
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(BROJ_T);  
                    stek.push(MINUS_T);                 
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                else if (preduvid == BROJ_T) {
#ifdef DEBUG
    std::cout << "F -> broj" << std::endl;
#endif 
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(BROJ_T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                else if (preduvid == ID_T) {
#ifdef DEBUG
    std::cout << "F -> id" << std::endl;
#endif
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(ID_T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                else if (preduvid == OZ_T) {
#ifdef DEBUG
    std::cout << "F -> ( E )" << std::endl;
#endif                    
                    /* uklanjamo neterminal sa steka */
                    stek.pop();
                    /* zamenjujemo ga njegovom desnom stranom */
                    stek.push(ZZ_T);
                    stek.push(E);
                    stek.push(OZ_T);
                    /* BITNO: pravilo dodajemo na stek sa desna na levo */
                }
                /* ako je na ulazu token koji ne pripada skupovima izbora */
                else {
                    /* prijavljujemo gresku i prekidamo parsiranje */
                    std::cerr << "Sintaksna greska:" 
                        << "Ocekivano: ID_T, BROJ_T, ZZ_T"<< std::endl;
                    exit(EXIT_FAILURE);
                }
                break;
/************************** Tokeni *************************/            
            default:
                /* ako je preduvidni simbol jednak onome koji ocekujemo */
                if (stek.top() == preduvid) {
                    /* skidamo token sa vrha steka */
                    stek.pop();
                    /* ucitavamo sledeci token sa ulaza */
                    preduvid = yylex();
                }
                /* ako se ocekivani token i token sa ulaza razlikuju */
                else {
                    /* prijavljujemo gresku */
                    std::cerr << "Sintaksna greska" << std::endl;
                    exit(EXIT_FAILURE);
                }
                break;
        }
    }

    /* ako smo ispraznili stek, onda je program sintaksno ispravan */
    std::cout << "Sve je ok" << std::endl;

    exit(EXIT_SUCCESS);
}