import sys
import re
import os

if len(sys.argv) != 2:
    print("args")
    sys.exit()

re_dir = re.compile(r"^(m[mnvrlia]|a[iaf])([01][0-9]|2[0-3])(00[1-9]|0[1-9][0-9]|[1-4]\d\d|500)$", re.I)
re_file = re.compile(r"^([1-9]|10)\.(c|cpp|java|py)$", re.I)

homedir = sys.argv[1]

for f in os.listdir(homedir):
    dirPath = os.path.join(homedir, f)
    m = re_dir.match(f)
    if os.path.isdir(dirPath) and m is not None:
        print("\n" + m.group())
        for sf in os.listdir(dirPath):
            filePath = os.path.join(dirPath, sf)
            m1 = re_file.match(sf)
            if os.path.isfile(filePath) and m1 is not None:
                print("\t", m1.group())