import sys
import re
import os

if len(sys.argv) != 3:
    print("args")
    sys.exit()

if re.match(r"^.*\.txt$", sys.argv[2], re.I) is None:
    print("ext")
    sys.exit()

# direktorijum sa radovima
homedir = sys.argv[1]
# spisak studenata koji su radili ispit
# indeks (mi format), ime i prezime
fileName = sys.argv[2]

re_linija = re.compile(r"^"
+r"\s*(?P<indeks>(m[mnvrlia]|a[aif])([01]\d|2[0-3])(00[1-9]|0[1-9]\d|[1-4]\d\d|500)),\s*"
+r"\s*(?P<ime>[A-Z][a-z]+(\s+[A-Z][a-z]+)+)"
+r"$")
studenti = {}

try:
    with open(fileName, "r") as f:
        for linija in f:
            if linija[-1] == '\n':
                linija = linija[:-1]

            m = re_linija.match(linija)
            if m is not None:
                indeks = m.group("indeks")
                ime = m.group("ime")
                studenti[indeks] = ime
except IOError:
    print("file error")
    sys.exit()


re_dir = re.compile(r"^(m[mnvrlia]|a[iaf])([01][0-9]|2[0-3])(00[1-9]|0[1-9][0-9]|[1-4]\d\d|500)$", re.I)
re_file = re.compile(r"^([1-9]|10)\.(c|cpp|java|py)$", re.I)

max_br_zad = 0
# (indeks, br_zad) : ekst
zadaci = {}

for f in os.listdir(homedir):
    dirPath = os.path.join(homedir, f)
    m = re_dir.match(f)
    if os.path.isdir(dirPath) and m is not None:
        indeks = m.group()
        for sf in os.listdir(dirPath):
            filePath = os.path.join(dirPath, sf)
            m = re_file.match(sf)
            if os.path.isfile(filePath) and m is not None:
                zad = int(m.group(1))
                ext = m.group(2)
                if zad > max_br_zad:
                    max_br_zad = zad
                zadaci[(indeks, zad)] = ext

# print(zadaci)

for indeks, ime in studenti.items():
    print("Ime: " + ime)
    for i in range(1, max_br_zad):
        if (indeks, i) in zadaci:
            print("\t" + str(i) + ". " + zadaci[(indeks, i)])
        else:
            print("\t" + str(i) + ". /")



