import sys
import re

if len(sys.argv) != 2:
    sys.exit("Args")

if re.match(r"^.+\.html$", sys.argv[1], re.I) is None:
    sys.exit("ext")

try:
    with open(sys.argv[1], "r") as f:
        data = f.read()
except IOError:
    sys.exit("open")

ri = re.compile(r"<tr>\s*"
+r"\s*<td>\s*(?P<ime>[A-Z][a-z]+(\s+[A-Z][a-z]+)+)\s*</td>"
+r"\s*<td>\s*(?P<prakticni>(0|[1-9]\d|100))\s*</td>"
+r"\s*<td>\s*(?P<usmeni>(0|[1-9]\d|100))\s*</td>"
+r"\s*</tr>", re.S)

studenti = []
poeni = []

recnik = {}

for m in ri.finditer(data):
    ime = m.group("ime")
    pr = int(m.group("prakticni"))
    us = int(m.group("usmeni"))

    studenti.append(ime)
    poeni.append((pr + us))

    recnik[ime] = pr + us

parovi = sorted(zip(poeni, studenti))
parovi.reverse()

for p, s in parovi:
    print(s, p, sep=', ')

