import sys
import re

if len(sys.argv) < 2:
    sys.exit("args")

if re.match(r"^.*\.txt$", sys.argv[1], re.I) is None:
    sys.exit("ext")

ucenici = {}

try:
    with open(sys.argv[1], "r") as f:
        data = f.read()
except IOError:
    sys.exit("open")

ri_ucenici = re.compile(r""
+r"(?P<mb>MB[A-Z0-9]{10})\s*;"
+r"(?P<ime>[A-Z][a-z]+(\s+[A-Z][a-z]+)+)\s*;"
+r"(?P<pol>M|Z)\s*;"
+r"(o(?P<opravdani>[0-9]+)n(?P<neopravdani>[0-9]+)nap(?P<napomene>[0-9]+))\s*;"
+r"(?P<ocene>[1-5](\s*,\s*[1-5]){9})"
+r"")

for m in ri_ucenici.finditer(data):
    mb = m.group("mb")
    ime = m.group("ime")
    pol = m.group("pol")
    opravdani = int(m.group("opravdani"))
    neopravdani = int(m.group("neopravdani"))
    napomene = int(m.group("napomene"))
    ocene = list(map(int, m.group("ocene").split(",")))
    prosek = 0
    for o in ocene:
        prosek += o
    prosek /= len(ocene)
    vladanje = 5
    vladanje -= (neopravdani // 6)
    vladanje -= (napomene // 2)
    if (vladanje <= 1):
        vladanje = "nedovoljno"
    elif (vladanje == 2):
        vladanje = "dovoljno"
    elif (vladanje == 3):
        vladanje = "dobar"
    elif (vladanje == 4):
        vladanje = "vrlo dobar"
    else:
        vladanje = "odlican"
    ucenici[mb] = [ime, pol, opravdani, neopravdani, napomene, prosek, vladanje]

if len(sys.argv) == 2:
    for k,v in ucenici.items():
        print(k, "\n\t", v)
elif len(sys.argv) == 4:
    if sys.argv[2] == "-v":
        for k,v in ucenici.items():
            if (sys.argv[3] == v[6]):
                print(k, "\n\t", v) 
    elif sys.argv[2] == "-p":
        prosek = float(sys.argv[3])
        for k,v in ucenici.items():
            if (prosek <= v[5]):
                print(k, "\n\t", v) 
    else:
        sys.exit("pogresna opcija")
else:
    sys.exit("args")