import sys
import re

if len(sys.argv) < 2:
    sys.exit("args")

if re.match(r"^.*\.xml$", sys.argv[1], re.I) is None:
    sys.exit("ext")

try:
    with open(sys.argv[1], "r") as f:
        data = f.read();
except IOError:
    sys.exit("open")

ri = re.compile(
r'<knjiga\s+rbr\s*=\s*"(?P<rbr>[0-9]+)"\s*>\s*'+
r"(?=.*?<autor>\s*(?P<autor>[A-Z][a-z]+(\s+[A-Z][a-z]+)+)\s*</autor>)"+
r"(?=.*?<naslov>\s*(?P<naslov>.*?)\s*</naslov>)"+
r"(?=.*?<god_izdanja>\s*(?P<god>[0-9]{4})\s*</god_izdanja>)"+
r"(?=.*?<izdavac>\s*(?P<izd>.*?)\s*</izdavac>)"+
r'(?=.*?<cena\s+valuta\s*=\s*"\s*(?P<valuta>[a-z]{3})\s*"\s*>\s*(?P<cena>[0-9]+)\s*</cena>)'
r".*?"+
r"</knjiga>"
, re.S)

knjige = {}

for m in ri.finditer(data):
    rbr = m.group("rbr")
    autor = m.group("autor")
    naslov = m.group("naslov")
    god = int(m.group("god"))
    if god < 1900 or god > 2023:
        continue
    izd = m.group("izd")
    valuta = m.group("valuta")
    cena = m.group("cena")

    knjige[rbr] = [autor, naslov, god, izd, valuta, cena]

if len(sys.argv) == 2:
    for k,v in knjige.items():
        print(k,v)
else:
    autor = False
    autorV = ""
    izdavac = False
    izdavacV = ""
    godina = False
    godinaV = 0

    k = 3
    if (sys.argv[2][0]) == '-':
        for c in sys.argv[2][1:]: #-agi
            if c == "a":
                autor = True
                autorV = sys.argv[k]
                k = k+1
            elif c == 'i':
                izdavac = True
                izdavacV = sys.argv[k]
                k = k+1
            elif c == "g":
                godina = True;
                godinaV = int(sys.argv[k])
                k = k+1
            else:
                sys.exit("opt")
    else:
        sys.exit("opt")

    for k,v in knjige.items():
        stampaj = True
        if autor and autorV != v[0]:
            stampaj = False
        if izdavac and izdavacV != v[3]:
            stampaj = False
        if godina and godinaV != v[2]:
            stampaj = False
        
        if stampaj:
            print(k,v)
