%option noyywrap

%{

#define I_CONST (1)
#define F_CONST (2) 

%}

%x comment

DIGIT   [0-9]

%%

[+-]?{DIGIT}+       {
                        ECHO;
                        return I_CONST;
                    }
[+-]?{DIGIT}+\.{DIGIT}*([Ee][+-]?{DIGIT}+)? {
                        ECHO;
                        return F_CONST;
                    }
"//".*$             { }
"/*"                { BEGIN(comment); }
<comment>[^*\n]*    { }
<comment>[*]*       { }
<comment>\n         { }
<comment>\*+"/"     { BEGIN(INITIAL); }
\n                  { ECHO; }
.                   { ECHO; }

%%

int main(int argc, char** argv) {

    if (argc >= 2) {
        yyin = fopen(argv[1], "r");
        if (yyin == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyin = stdin;
        yyout = stdout;
    }
    if (argc >= 3) {
        yyout = fopen(argv[2], "w");
        if (yyout == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyout = stdout;
    }

    int token = 0;
    while ((token = yylex()) != 0) {
        switch (token) {
            case I_CONST:
                printf("Ceo broj: %s\n", yytext);
                break;
            case F_CONST:
                printf("Realan broj: %s\n", yytext);
                break;
        }
    }

    if (yyin != stdin)
        fclose(yyin);
    if (yyout != stdout)
        fclose(yyout);


    exit(EXIT_SUCCESS);
}