%option noyywrap

%{

#define I_CONST (1)
#define F_CONST (2) 
#define PREPROC_DIR (3)
#define KEYWORD     (4)
#define ID          (5)
#define SEP         (6)
#define TERM        (7)
#define OZ          (8)
#define ZZ          (9)
#define OB          (10)
#define ZB          (11)
#define A_OP        (12)
#define R_OP        (13)
#define DODELA      (14)
#define GRESKA      (15)
#define STRING      (16)

%}

%x comment

DIGIT   [0-9]

%%

#.*$    { ECHO; return PREPROC_DIR;}
int|double|float|short|char|if|else|for|while|extern     { ECHO; return KEYWORD; }
[a-zA-Z_][a-zA-Z0-9_]*  {ECHO; return ID;}
,       {ECHO; return SEP;}
;       {ECHO; return TERM;}
"("     {ECHO; return OZ;}
")"     {ECHO; return ZZ;}
"{"     {ECHO; return OB;}
"}"     {ECHO; return ZB;}
"<="    {ECHO; return R_OP;}
">="    {ECHO; return R_OP;}
"="     {ECHO; return DODELA;}
"++"    {ECHO; return A_OP;}
"--"    {ECHO; return A_OP;}
"\""[^"]*"\"" {ECHO; return STRING;}
[+*/%-] {ECHO; return A_OP;}
[<>]    {ECHO; return R_OP;} 
[+-]?{DIGIT}+       {
                        ECHO;
                        return I_CONST;
                    }
[+-]?{DIGIT}+\.{DIGIT}*([Ee][+-]?{DIGIT}+)? {
                        ECHO;
                        return F_CONST;
                    }
"//".*$             { }
"/*"                { BEGIN(comment); }
<comment>[^*\n]*    { }
<comment>[*]*       { }
<comment>\n         { }
<comment>\*+"/"     { BEGIN(INITIAL); }
[ \n\t\\]             { ECHO; }
.                   { 
                        return GRESKA;
                     }

%%

int main(int argc, char** argv) {

    if (argc >= 2) {
        yyin = fopen(argv[1], "r");
        if (yyin == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyin = stdin;
        yyout = stdout;
    }
    if (argc >= 3) {
        yyout = fopen(argv[2], "w");
        if (yyout == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyout = stdout;
    }

    int token = 0;
    while ((token = yylex()) != 0) {
        int iskoci = 0;
        switch (token) {
            case I_CONST:
                printf("Ceo broj: %s\n", yytext);
                break;
            case F_CONST:
                printf("Realan broj: %s\n", yytext);
                break;
            case PREPROC_DIR:
                printf("Preproc: %s\n", yytext);
                break;
            case KEYWORD:
                printf("Keyword: %s\n", yytext);
                break;
            case ID:
                printf("ID: %s\n", yytext);
                break;
            case SEP:
                printf("Separator: %s\n", yytext);
                break;
            case TERM:
                printf("Terminator: %s\n", yytext);
                break;
            case OZ:
                printf("OZ: %s\n", yytext);
                break;
            case ZZ:
                printf("ZZ: %s\n", yytext);
                break;
            case OB:
                printf("OB: %s\n", yytext);
                break;
            case ZB:
                printf("ZB: %s\n", yytext);
                break;
            case A_OP:
                printf("Arimeticki operator: %s\n", yytext);
                break;
            case R_OP:
                printf("Relacijski operator: %s\n", yytext);
                break;
            case DODELA:
                printf("Dodela: %s\n", yytext);
                break;
            case STRING:
                printf("String: %s\n", yytext);
                break;
            case GRESKA:
                printf("Leksicka greska: %s\n", yytext);
                iskoci = 1;
                break;
        }
        if (iskoci)
            break;
    }

    if (yyin != stdin)
        fclose(yyin);
    if (yyout != stdout)
        fclose(yyout);


    exit(EXIT_SUCCESS);
}