%option noyywrap

%{
    #include <string.h>
    int vrednost = 0;    
%}

hiljade     M+
stotine     C+|CD|DC*|CM
desetice    X+|XL|LX*|XC
jedinice    I*|IV|VI*|IX

%%

{hiljade}   {
                vrednost += yyleng*1000;
            }
{stotine}   {
                if (strcmp(yytext, "CM") == 0) {
                    vrednost += 900;
                }
                else if (strcmp(yytext, "CD") == 0) {
                    vrednost += 400;
                }
                else {

                    if (yytext[0] == 'D') {
                        vrednost += 500;
                        if (yyleng <= 4) {
                            vrednost += (yyleng - 1)*100;
                        }
                        else {
                            printf("Pogresno formatiranje\n");
                            return 1;
                        }
                    }
                    else {
                        if (yyleng <= 3) {
                            vrednost += (yyleng)*100;
                        }
                        else {
                            printf("Pogresno formatiranje\n");
                            return 1;
                        }
                    }
                }
            }
{desetice}  {
                if (strcmp(yytext, "XC") == 0) {
                    vrednost += 90;
                }
                else if (strcmp(yytext, "XL") == 0) {
                    vrednost += 40;
                }
                else {

                    if (yytext[0] == 'L') {
                        vrednost += 50;
                        if (yyleng <= 4) {
                            vrednost += (yyleng - 1)*10;
                        }
                        else {
                            printf("Pogresno formatiranje\n");
                            return 1;
                        }
                    }
                    else {
                        if (yyleng <= 3) {
                            vrednost += (yyleng)*10;
                        }
                        else {
                            printf("Pogresno formatiranje\n");
                            return 1;
                        }
                    }
                }
            }
{jedinice}  {
                if (strcmp(yytext, "IX") == 0) {
                    vrednost += 9;
                }
                else if (strcmp(yytext, "IV") == 0) {
                    vrednost += 4;
                }
                else {

                    if (yytext[0] == 'V') {
                        vrednost += 5;
                        if (yyleng <= 4) {
                            vrednost += (yyleng - 1);
                        }
                        else {
                            printf("Pogresno formatiranje\n");
                            return 1; 
                        }
                    }
                    else {
                        if (yyleng <= 3) {
                            vrednost += (yyleng);
                        }
                        else {
                            printf("Pogresno formatiranje\n");
                            return 1;
                        }
                    }
                }
            }
.|\n        {
                if (vrednost > 0) {
                    printf("%d", vrednost);
                    vrednost = 0;
                }
                ECHO;
            }

%%

int main() { 

    yylex();

    return 0;
}