%option noyywrap

%{
    int broj_otvorenih = 0;
%}

%%

"("     { ECHO; broj_otvorenih++;}
")"     {
            ECHO;
            broj_otvorenih--;
            if (broj_otvorenih < 0) {
                // printf("Nisu uparene\n");
                // exit(EXIT_SUCCESS);
                return -1;
            }
        }
\n      {   
            ECHO;
            //printf("%s", yytext);
        }
.       {ECHO;}

%%

int main() {

    int retVal = yylex();

    if (retVal == -1) {
        printf("Nisu uparene\n");
    }
    else {
        if (broj_otvorenih == 0)
            printf("Uparene su\n");
        else
            printf("Nisu uparene\n");
    }
}