%option noyywrap

%{
    #define I_CONST (1)
    #define F_CONST (2)
    #define KEYWORD (3)
    #define ID      (4)
    #define PREPROC (5)
    #define OZ      (6)
    #define ZZ      (7)
    #define OB      (8)
    #define ZB      (9)
    #define TERM    (10)
    #define SEP     (11)
    #define DODELA  (16)
    #define A_OP    (12)
    #define R_OP    (13)
    #define COMM    (14)
    #define STRING  (15)
    #define ERR     (17)
%}

%x COMMENT

DIGIT   [0-9]

%%

int|double|return|if|else|for|while|do|switch|case|void|break {return KEYWORD;}
[A-Za-z_][A-Za-z0-9_]*  {return ID;}
#.*         {return PREPROC;}
\"[^"]*\"    {return STRING;}
[+-]?{DIGIT}+       { return I_CONST; }
[+-]?{DIGIT}+\.{DIGIT}*([Ee][+-]?{DIGIT}+)? {
                        return F_CONST;
                    }
"/*"    { BEGIN(COMMENT);return COMM;}
<COMMENT>[^*\n]*     { return COMM;}
<COMMENT>"*"*       { return COMM;}
<COMMENT>\n         { return COMM;}
<COMMENT>\*+"/"     {BEGIN(INITIAL);return COMM;} 
[+*/-]  {return A_OP;}
"=="    {return R_OP;}
"<="    {return R_OP;}
">="    {return R_OP;}
[<>]    {return R_OP;}
,       {return SEP;}
;       {return TERM;}
=       {return DODELA;}
"("     {return OZ;}
")"     {return ZZ;}
"{"     {return OB;}
"}"     {return ZB;}
[ \n\t] { }
.       { return ERR;} 


%%

int main(int argc, char** argv) {

    if (argc >= 2) {
        yyin = fopen(argv[1],"r");
        if (yyin == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyin = stdin;
    }

    if (argc >= 3) {
        yyout = fopen(argv[1],"w");
        if (yyout == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyout = stdout;
    }

    int token = 0;

    while ((token = yylex()) != 0) {

        switch (token) {
            case I_CONST:
                printf("Ceo broj: %s\n", yytext);
                break;
            case F_CONST:
                printf("Realan broj: %s\n", yytext);
                break;
            case KEYWORD:
                printf("Kljucna rec: %s\n", yytext);
                break;
            case ID:
                printf("ID: %s\n", yytext);
                break;
            case STRING:
                printf("String: %s\n", yytext);
                break;
            case COMM:
                printf("Komentar: %s\n", yytext);
                break;
            case PREPROC:
                printf("Preprecesorska direktiva: %s\n", yytext);
                break;
            case A_OP:
                printf("Artimeticki operatori: %s\n", yytext);
                break;
            case R_OP:
                printf("Relacijski operatori: %s\n", yytext);
                break;
            case OZ:
                printf("OZ: %s\n", yytext);
                break;
            case ZZ:
                printf("ZZ: %s\n", yytext);
                break;
            case OB:
                printf("OB: %s\n", yytext);
                break;
            case ZB:
                printf("ZB: %s\n", yytext);
                break;
            case DODELA:
                printf("Dodela: %s\n", yytext);
                break;
            case SEP:
                printf("Separator: %s\n", yytext);
                break;
            case TERM:
                printf("Terminator: %s\n", yytext);
                break;
            case ERR:
                printf("Leksicka greska: %s\n", yytext);
                return 0;
        }
    }

    if (yyin != stdin)
        fclose(yyin);
    if (yyout != stdout)
        fclose(yyout);
 
    exit(EXIT_SUCCESS);
}