%option noyywrap

%{
    void printString(char* s);
    void printChar(char c);
%}

%x COMMENT

DIGIT   [0-9]

%%

int|double|return|if|else|for|while|do|switch|case|void|break {
    fprintf(yyout, "<span style=\"font-weight:bold;\">%s</span>", yytext);
    }
[A-Za-z_][A-Za-z0-9_]*  {
        fprintf(yyout, "<span>%s</span>", yytext);
    }
#.*         {
        fprintf(yyout, "<span style=\"color:violet;\">");
        printString(yytext);
        fprintf(yyout, "</span>");
}
\"[^"]*\"    {
    fprintf(yyout, "<span style=\"color:red;\">");
    printString(yytext);
    fprintf(yyout, "</span>");
}
[+-]?{DIGIT}+       { 
    fprintf(yyout, "<span style=\"color:blue;\">%s</span>", yytext);
 }
[+-]?{DIGIT}+\.{DIGIT}*([Ee][+-]?{DIGIT}+)? {
                        fprintf(yyout, "<span style=\"color:blue;\">%s</span>", yytext);
                    }
"/*"    { fprintf(yyout, "<span style=\"color:gray;\">%s</span>", yytext);}
<COMMENT>[^*\n]*     { 
    fprintf(yyout, "<span style=\"color:gray;\">");
    printString(yytext);
    fprintf(yyout, "</span>");
}
<COMMENT>"*"*       { fprintf(yyout, "<span style=\"color:gray;\">%s</span>", yytext);}
<COMMENT>\n         { fprintf(yyout, "<br/>"); }
<COMMENT>\*+"/"     {fprintf(yyout, "<span style=\"color:gray;\">%s</span>", yytext);} 
[+*/-]  {fprintf(yyout, "<span>%s</span>", yytext);}
"=="    {fprintf(yyout, "<span>%s</span>", yytext);}
"<="    {fprintf(yyout, "<span>");
    printString(yytext);
    fprintf(yyout, "</span>");}
">="    {fprintf(yyout, "<span>");
    printString(yytext);
    fprintf(yyout, "</span>");}
[<>]    {fprintf(yyout, "<span>");
    printString(yytext);
    fprintf(yyout, "</span>");}
,       {fprintf(yyout, "<span>%s</span>", yytext);}
;       {fprintf(yyout, "<span>%s</span>", yytext);}
=       {fprintf(yyout, "<span>%s</span>", yytext);}
"("     {fprintf(yyout, "<span>%s</span>", yytext);}
")"     {fprintf(yyout, "<span>%s</span>", yytext);}
"{"     {fprintf(yyout, "<span>%s</span>", yytext);}
"}"     {fprintf(yyout, "<span>%s</span>", yytext);}
[ \n\t] { fprintf(yyout, "<span>");
    printString(yytext);
    fprintf(yyout, "</span>");}
.       { 
    return -1;
    } 


%%

int main(int argc, char** argv) {

    if (argc >= 2) {
        yyin = fopen(argv[1],"r");
        if (yyin == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyin = stdin;
    }

    if (argc >= 3) {
        yyout = fopen(argv[2],"w");
        if (yyout == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyout = stdout;
    }

    fprintf(yyout,"<html><head></head><body>");
    yylex();
    fprintf(yyout, "</body></html>");

    if (yyin != stdin)
        fclose(yyin);
    if (yyout != stdout)
        fclose(yyout);
 
    exit(EXIT_SUCCESS);
}

void printString(char* s) {

    for (int i = 0; s[i] != 0; i++) {
        printChar(s[i]);
    }
}

void printChar(char c) {
    
    switch(c) {
        case '<':
            fprintf(yyout, "&lt");
            break;
        case '>':
            fprintf(yyout, "&gt");
            break;
        case '&':
            fprintf(yyout, "&amp");
            break;
        case ' ':
            fprintf(yyout, "&nbsp");
            break;
        case '\t':
            fprintf(yyout, "&nbsp&nbsp&nbsp&nbsp");
            break;
        case '\n':
            fprintf(yyout, "<br/>");
            break;
        default:
            fprintf(yyout, "%c", c);
            break;
    }
}  