#ifndef DINAMICKI_NIZ_H
#define DINAMICKI_NIZ_H

#include <iostream>
#include <exception>

/* podrazumevana velicina niza */
#define DEFAULT_SIZE (32)
/* podrazumevana politika sirenja niza */
#define DEFAULT_STEP (2)

/* deklaracija klase DinamickiNiz */
class DinamickiNiz
{
private:
	/* Klasa koristi dinamicki resurs koji alociramo na hipu, sto nalaze
	 * da moramo da obezbedimo veliku trojku: (the big three)
	 * 1. Konstruktor kopije - koji izvrsava duboko kopiranje atributa klase.
	 * 2. Operator dodele - koji na ispravan nacin kopira atribute jednog objekta
	 *						u drugi postojeci objekat. 
	 * 3. Destruktor - koji oslobadja sve dinamicke resurse.
	 * 
	 * Pored obezbedjivanja velike trojke, duzni smo da pratimo i RAII koncept koji
	 * nalaze da sve neophodne dinamicke resurse moramo da obezbedimo u konstruktoru
	 * (i nigde vise) i da moramo da ih oslobodimo suprotnim redosledom u destruktoru. 
	 */
	double* _niz;
	int _capacity;
	int _size;
public:
	DinamickiNiz();
	DinamickiNiz(int n, double val = 0);
	DinamickiNiz(const DinamickiNiz& dn);
	DinamickiNiz& operator =(const DinamickiNiz& dn);
	~DinamickiNiz();

	void show(std::ostream& s) const;

	int size() const;

	void dodajNaKraj(double x);
	void obrisiSaKraja();
	int pronadji(double x) const;

	double& operator [](int i);
	const double& operator [](int i) const;
};

/* globalni operator za stampanje niza */
std::ostream& operator <<(std::ostream& s, const DinamickiNiz& dn);
/* globalni operator za ucitavanje niza nema smisla, pa ga zato ne implementiramo */

#endif