#include "KompleksniBroj.hpp"

KompleksniBroj::KompleksniBroj(double re, double im) {

    _re = re;
    _im = im;
}

double KompleksniBroj::Re() const {
    return _re;
}
void KompleksniBroj::Re(double re) {
    _re = re;
}

double KompleksniBroj::Im() const {
    return _im;
}
void KompleksniBroj::Im(double im) {
    _im = im;
}

KompleksniBroj* KompleksniBroj::operator +(const KompleksniBroj& kb) const {

    /* kompleksne brojeve vracamo kao pokazivace na objekte na hipu 
     * zbog toga objekat instanciramo uz pomoc operatora new
     */
    return new KompleksniBroj(_re + kb._re, _im + kb._im);
}
KompleksniBroj* KompleksniBroj::operator -(const KompleksniBroj& kb) const {

    return new KompleksniBroj(_re - kb._re, _im - kb._im);
}
KompleksniBroj* KompleksniBroj::operator *(const KompleksniBroj& kb) const {

    double re = _re*kb._re - _im*kb._im;
    double im = _re*kb._im + _im*kb._re;

    return new KompleksniBroj(re, im);
}
KompleksniBroj* KompleksniBroj::operator /(const KompleksniBroj& kb) const {

    double d = kb._re*kb._re + kb._im*kb._im;
    double re = _re*kb._re + _im*kb._im;
    double im = -_re*kb._im + _im*kb._re;

    return new KompleksniBroj(re/d, im/d);
}

KompleksniBroj KompleksniBroj::operator -() const {

    /* standardno vracanje po vrednosti */
    return KompleksniBroj(-_re, -_im);
}
KompleksniBroj KompleksniBroj::operator ~() const {

    return KompleksniBroj(_re, -_im);
}

bool KompleksniBroj::operator ==(const KompleksniBroj& kb) const {

    if (_re == kb._re && _im == kb._im)
        return true;

    return false;
}
bool KompleksniBroj::operator !=(const KompleksniBroj& kb) const {

    return !(*this == kb);
}

double KompleksniBroj::Moduo() const {

    return sqrt(_re*_re + _im*_im);
}
double KompleksniBroj::Arg() const {

    return atan2(_im, _re);
}

void KompleksniBroj::show(std::ostream& s) const {

    s << _re;
    if (_im < 0)
        s << " - " << fabs(_im) << "*i";
    else if (_im > 0)
        s << " + " << fabs(_im) << "*i";
}

std::ostream&
operator <<(std::ostream& s, const KompleksniBroj& kb) {

    kb.show(s);
    return s;
}
