%option noyywrap

%{
    /* ukjucujemo potrebna zaglavlja */
    #include <iostream>
    #include <cstdlib>
    #include <cmath>
    #include <vector>
    #include <map>

    /* obratiti paznju na redosled */
    #include "Polinom.hpp"
    #include "parser.tab.hpp"
%}

%%
print   {return PRINT_T;}
deg     {return DEG_T;}
poly    {return POLY_T;}
int     {return INT_T;}
[A-Za-z_][A-Za-z0-9_]*  {
                            /* kreiramo kopiju stringa koju pamtimo u uniji */
                            yylval.s = new std::string(yytext);
                            return ID;
                        }
[0-9]+(\.[0-9]*)?       {
                            /* u uniji pamtimo vrednost broja */
                            yylval.d = atof(yytext);
                            return BROJ;
                        }
"=="    { return EQ_T; }
"!="    { return NEQ_T; }
"["     { return *yytext; }
"]"     { return *yytext; }
"'"     { return *yytext; }
[+*/()=<>;,-] {return *yytext; }
[ \t\n] { }
.       {
            std::cerr << "Leksicka greska: " << (*yytext) << std::endl;
            exit(EXIT_FAILURE);
        }

%%