#include "SymbolTable.hpp"

bool SymbolTable::DefineVariable(const std::string& name, int val) {

    if (VariableDefined(name))
        return false;
    
    _vars[name] = val;
    return true;
}

bool SymbolTable::GetVariable(const std::string& name, int* pval) const {

    auto it = _vars.find(name);
    if (it == _vars.end())
        return false;
    
    *pval = it->second;
    return true;
}

bool SymbolTable::VariableDefined(const std::string& name) const {

    return _vars.find(name) != _vars.end();
}

bool SymbolTable::UpdateVariable(const std::string& name, int val){

    if (!VariableDefined(name))
        return false;

    _vars[name] = val;
    return true;
}