#ifndef GRAPH_H
#define GRAPH_H

#include <iostream>
#include <vector>
#include <map>
#include <exception>
#include <algorithm>

class Graph {
public:
    Graph();
    Graph(const Graph& g);
    ~Graph();
    Graph& operator =(const Graph& g);

    void AddNode(int nodeNum, std::vector<int>* edges);
    void DropNode(int nodeNum);

    Graph* Clone();
    
    Graph* operator +(const Graph& g) const;
    Graph* operator *(const Graph& g) const;
    
    Graph* operator ~() const;

    std::vector<int>* at(int index);

    std::vector<std::vector<int>>& Directed();
    std::vector<std::vector<int>>& Undirected();

    void BuildMatrixRep();
    void show(std::ostream& s) const;

private:

    std::map<int, std::vector<int>*> _graph;
    int _max;

    std::vector<std::vector<int>> _directed;
    std::vector<std::vector<int>> _undirected;
};

std::ostream& operator <<(std::ostream& s, const Graph& g);
std::ostream& operator <<(std::ostream& s, const std::vector<std::vector<int>>& mat);


#endif