#include "sym_table.hpp"

SymbolTable::SymbolTable()
     : _promenljive() {

    }
SymbolTable::SymbolTable(const SymbolTable& st) 
    : _promenljive() {
    
    for (auto& kv : st._promenljive) {
        _promenljive[kv.first] = kv.second->Clone();
    }
}
SymbolTable::~SymbolTable() {

    for (auto& kv : _promenljive)
        delete kv.second;
}
SymbolTable& SymbolTable::operator =(const SymbolTable& st) {

    if (this == &st)
        return *this;

    for (auto& kv : _promenljive)
        delete kv.second;
        
    _promenljive.clear();

    for (auto& kv : st._promenljive) {
        _promenljive[kv.first] = kv.second->Clone();
    }

    return *this;
}
bool SymbolTable::AddVariable(const std::string& s, Graph* g) {

    auto it = _promenljive.find(s);
    
    if (it != _promenljive.end())
        throw std::invalid_argument("Promenljiva vec definisana");

    _promenljive[s] = g;

    return true;
}
bool SymbolTable::Defined(const std::string& s) {
    
    return _promenljive.find(s) != _promenljive.end();
}
Graph* SymbolTable::Value(const std::string& s) {

    auto it = _promenljive.find(s);
    
    if (it == _promenljive.end())
        throw std::invalid_argument("Promenljiva nije definisana");

    return it->second->Clone();
}
bool SymbolTable::Update(const std::string& s, Graph* g) {

    auto it = _promenljive.find(s);
    
    if (it == _promenljive.end())
        return false;

    delete it->second;

    _promenljive[s] = g;
    return true;
}