%option noyywrap

%{
    #include <iostream>
    #include <cstdlib>
    #include <set>
    #include <map> 

    #include "skup.hpp"
    #include "types.hpp"
    #include "symbols.hpp"
    #include "syn_tree.hpp"
    #include "parser.tab.hpp"
%}

%%

def     { return DEF_T; }
print   { return PRINT_T; }
univ    { return UNIV_T; }
in      { return IN_T; }
sub     { return SUB_T; }
size    { return SIZE_T; }
[a-zA-Z_][a-zA-Z0-9_]*  {
            yylval.s = new std::string(yytext);
            return ID_T;
        }
[0-9]+  {
            yylval.v = std::stoi(yytext);
            return BROJ_T;
        }
"/\\"   { return PRESEK_T; }
"\\/"   { return UNIJA_T; }
"\\"    { return RAZLIKA_T; }
"~"     { return CPL_T; }
"=="    { return EQ_T; }
"!="    { return NEQ_T; }
[(){}\[\];,=-]      { return *yytext;}
[ \n\t] { }
.       {
            std::cerr << "Leksicka greska: " << (*yytext) << std::endl;
            exit(EXIT_FAILURE);
        }

%%

