#include "symbols.hpp"

SymbolTable::SymbolTable() : _vars() {
    
}

bool SymbolTable::Defined(const std::string& s) {
    return _vars.find(s) != _vars.end();
}
bool SymbolTable::Define(const std::string& s, Type* t) {

    if (Defined(s))
        return false;

    _vars[s] = t;
    return true;
}
bool SymbolTable::Update(const std::string& s, Type* t) {

    auto it = _vars.find(s);
    
    if (it == _vars.end())
        return false;


    delete it->second;
    it->second = t;
    return true;
}
Type* SymbolTable::GetVar(const std::string& s) {

    auto it = _vars.find(s);
    
    if (it == _vars.end())
        return nullptr;

    return it->second;
}