#ifndef SYMBOLS_H
#define SYMBOLS_H

#include <iostream>
#include <map>
#include "types.hpp"

class SymbolTable {
public:
    SymbolTable();

    bool Defined(const std::string& s);
    bool Define(const std::string& s, Type* t);
    bool Update(const std::string& s, Type* t);
    Type* GetVar(const std::string& s);
    
private:
    std::map<std::string, Type*> _vars;
};

#endif

