#ifndef SYN_TREE_H
#define SYN_TREE_H

#include <iostream>
#include <cstdlib>
#include <exception>
#include <vector>
#include "symbols.hpp"

class SynTreeNode {
public:

    virtual ~SynTreeNode() {}

    virtual Type* Execute(SymbolTable& st) const = 0;
    virtual void Compile(SymbolTable& st, std::ostream& s) const = 0;
    virtual SynTreeNode* Clone() const = 0;
    virtual void show(std::ostream& s) const = 0;
};

std::ostream& operator <<(std::ostream& s, const SynTreeNode* stn);

class BrojConstNode : public SynTreeNode {
public:
    BrojConstNode(int v);

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:   
    int _value;
};

class StringConstNode : public SynTreeNode {
public:
    StringConstNode(const std::string& s);

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:   
    std::string _value;
};

class SizeNode : public SynTreeNode {
public:
    SizeNode(SynTreeNode* exp);
    SizeNode(const SizeNode& sn);
    ~SizeNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:   
    SynTreeNode* _exp;
};

class ListaBrojevaNode : public SynTreeNode {
public:
    ListaBrojevaNode(SynTreeNode* left, SynTreeNode* right);
    ListaBrojevaNode(const ListaBrojevaNode& sn);
    ~ListaBrojevaNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    SynTreeNode* _left, *_right;
};

class SkupNode : public SynTreeNode {
public:
    SkupNode(SynTreeNode* exp);
    SkupNode(const SkupNode& sn);
    ~SkupNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:   
    SynTreeNode* _exp;
};

class BinaryOperationNode : public SynTreeNode {
public:
    BinaryOperationNode(SynTreeNode* left, SynTreeNode* right, const std::string& op);
    BinaryOperationNode(const BinaryOperationNode& b);
    ~BinaryOperationNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    SynTreeNode* _left;
    SynTreeNode* _right;
    std::string _op;
};

class IdentifierNode : public SynTreeNode {
public:
    IdentifierNode(const std::string& id);

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    std::string _id;
};

class ComplementNode : public SynTreeNode {
public:
    ComplementNode(SynTreeNode* exp);
    ComplementNode(const ComplementNode& cn);
    ~ComplementNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    SynTreeNode* _exp;
};

class UniverzalniNode : public SynTreeNode {
public:
    UniverzalniNode(SynTreeNode* left, SynTreeNode* right);
    UniverzalniNode(const UniverzalniNode& un);
    ~UniverzalniNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    SynTreeNode* _left;
    SynTreeNode* _right;
};

class LogickiNode : public SynTreeNode {
public:
    LogickiNode(SynTreeNode* exp);
    LogickiNode(const LogickiNode& ln);
    ~LogickiNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    SynTreeNode* _exp;
};

class PrintNode : public SynTreeNode {
public:
    PrintNode(SynTreeNode* exp);
    PrintNode(const PrintNode& ln);
    ~PrintNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    SynTreeNode* _exp;
};

class DefinitionNode : public SynTreeNode {
public:
    DefinitionNode(const std::string& id, SynTreeNode* exp, bool update = false);
    DefinitionNode(const DefinitionNode& ln);
    ~DefinitionNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    SynTreeNode* _exp;
    std::string _id;
    bool _update;
};

class SequenceNode : public SynTreeNode {
public:
    SequenceNode(SynTreeNode* exp);
    SequenceNode(const SequenceNode& ln);
    ~SequenceNode();

    virtual Type* Execute(SymbolTable& st) const;
    virtual void Compile(SymbolTable& st, std::ostream& s) const;
    virtual SynTreeNode* Clone() const;
    virtual void show(std::ostream& s) const;

    void Dodaj(SynTreeNode* exp);
private:
    std::vector<SynTreeNode*> _stmts;
};

#endif
