#ifndef TYPES_H
#define TYPES_H

#include <iostream>
#include <cstdlib>
#include <sstream>
#include "skup.hpp"

class Type {
public:
    virtual bool GetBool() const = 0;
    virtual int GetInt() const = 0;
    virtual std::string GetString() const = 0;
    virtual Skup GetSkup() const = 0;
    virtual Type* Clone() const = 0;
    virtual void show(std::ostream& s) const = 0;
};

std::ostream& operator <<(std::ostream& s, const Type* t);

class BoolType : public Type {
public:
    BoolType(bool v);

    virtual bool GetBool() const;
    virtual int GetInt() const;
    virtual std::string GetString() const;
    virtual Skup GetSkup() const;
    virtual Type* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    bool _value;    
};

class IntType : public Type {
public:
    IntType(int v);

    virtual bool GetBool() const;
    virtual int GetInt() const;
    virtual std::string GetString() const;
    virtual Skup GetSkup() const;
    virtual Type* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    int _value;
};

class StringType : public Type {
public:
    StringType(const std::string& s);

    virtual bool GetBool() const;
    virtual int GetInt() const;
    virtual std::string GetString() const;
    virtual Skup GetSkup() const;
    virtual Type* Clone() const;
    virtual void show(std::ostream& s) const;
private:
    std::string _value;
};

class SkupType : public Type {
public:
    SkupType(const Skup& s);
    SkupType(const SkupType& st);

    virtual bool GetBool() const;
    virtual int GetInt() const;
    virtual std::string GetString() const;
    virtual Skup GetSkup() const;
    virtual Type* Clone() const;
    virtual void show(std::ostream& s) const;

    void Dodaj(int v);
private:
    Skup _value;
};

#endif

