#ifndef __IZRAZ_HPP__
#define __IZRAZ_HPP__

#include <vector>
#include <iostream>
using namespace std;
class Izraz{
	public:
		virtual ~Izraz(){}
		virtual Izraz* Clone() const=0;
		virtual std::vector<std::pair<float, float>> izracunaj() const = 0;
};


class LIzraz{
	public:
		virtual ~LIzraz(){}
		virtual LIzraz* Clone() const=0;
		virtual bool izracunaj() const = 0;
};

class Podskup: public LIzraz {
public:
		~Podskup();
		Podskup(Izraz* oper1, Izraz* oper2):op1(oper1), op2(oper2){}
		bool izracunaj() const;
		LIzraz* Clone() const;
	private:
		Izraz* op1;
		Izraz* op2;
};

class Jednako: public LIzraz {
	public:
		~Jednako();
		Jednako(Izraz* oper1, Izraz* oper2):op1(oper1), op2(oper2){}
		bool izracunaj() const;
		LIzraz* Clone() const;
	private:
		Izraz* op1;
		Izraz* op2;

};

class Konstanta: public Izraz {
	public:
		~Konstanta(){};
		Konstanta(std::vector<std::pair<float, float>> i):intervali(i){}
		std::vector<std::pair<float, float>> izracunaj() const;
		Izraz* Clone() const;
	private:
		std::vector<std::pair<float, float>> intervali;
};


class Promenljiva: public Izraz {
	public:
		~Promenljiva(){};
		Promenljiva(string i):ime(i){}
		std::vector<std::pair<float, float>> izracunaj() const;
		Izraz* Clone() const;
	private:
		string ime;
};

class Plus: public Izraz{
	public:
		~Plus();
		Plus(Izraz* oper1, Izraz* oper2):op1(oper1), op2(oper2){}
		std::vector<std::pair<float, float>> izracunaj() const;
		Izraz* Clone() const;
	private:
		Izraz* op1;
		Izraz* op2;
		
};

class Puta: public Izraz{
	public:
		~Puta();
		Puta(Izraz* oper1, Izraz* oper2):op1(oper1), op2(oper2){}
		std::vector<std::pair<float, float>> izracunaj() const;
		Izraz* Clone() const;
	private:
		Izraz* op1;
		Izraz* op2;
		
};

class Minus: public Izraz{
	public:
		~Minus();
		Minus(Izraz* oper1, Izraz* oper2):op1(oper1), op2(oper2){}
		std::vector<std::pair<float, float>> izracunaj() const;
		Izraz* Clone() const;
	private:
		Izraz* op1;
		Izraz* op2;
		
};

class Komplement: public Izraz{
	public:
		~Komplement();
		Komplement(Izraz* oper1):op1(oper1){}
		std::vector<std::pair<float, float>> izracunaj() const;
		Izraz* Clone() const;
	private:
		Izraz* op1;
		
		
};

class PlusList: public Izraz{
	public:
		~PlusList();
		PlusList(std::vector<Izraz*> iz):izrazi(iz){}
		std::vector<std::pair<float, float>> izracunaj() const;
		Izraz* Clone() const;
	private:
		std::vector<Izraz*> izrazi;
		
		
};



#endif
